#!/bin/bash

# 设置颜色输出
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m' # 重置颜色

# 定义变量
HOST="192.168.123.188"
USER="cat"
PASSWORD="temppwd"
LOCAL_PASSWORD="Robot@1234"
xunfei_password="1qA2wS"
TIMEOUT=10

# 打印带颜色的信息函数
print_info() {
    echo -e "${GREEN}[INFO]${NC} $1"
}

print_warning() {
    echo -e "${YELLOW}[WARNING]${NC} $1"
}

print_error() {
    echo -e "${RED}[ERROR]${NC} $1"
}

# 检查上一步操作是否成功
check_status() {
    if [ $? -eq 0 ]; then
        print_info "$1"
        return 0
    else
        print_error "$2"
        exit 1
    fi
}

# 检查参数是否传入
if [ $# -eq 0 ]; then
    print_error "请提供要解压的tar.gz文件名作为参数"
    echo "用法: $0 <tar.gz文件名>"
    exit 1
fi

TAR_FILE="$1"

###########  本地指令    ###########
echo "===== 执行本地指令 ====="
echo "$LOCAL_PASSWORD" | sudo -S apt install expect -y
echo "$LOCAL_PASSWORD" | sudo -S apt install sshpass -y

# ======================
# 0. 导航算法部署
# ======================
print_warning "即将更新导航算法版本..."
read -p "是否更新算法版本? (y/N): " confirm
if [[ $confirm == [yY] || $confirm == [yY][eE][sS] ]]; then
	print_info "开始更新算法..."
	nav_package=$(ls -t ~/RobotAlgorithmGen1_*.zip 2>/dev/null | head -1)
	if [[ ! -f "$nav_package" ]]; then
        print_error "文件不存在: $nav_package"
        exit 1
    fi
    if [ -d ~/RobotAlgorithmGen1 ]; then
    	echo "$LOCAL_PASSWORD" | sudo -S rm -r ~/RobotAlgorithmGen1/install
    	echo "$LOCAL_PASSWORD" | sudo -S rm -r ~/RobotAlgorithmGen1/service
    	print_info "旧版本软件删除成功"
    else
    	print_warning "旧版本软件不存在，跳过删除"
    fi
	echo "$LOCAL_PASSWORD" | sudo -S unzip "$nav_package"
	rm "$nav_package"
	
else
	print_warning "跳过算法更新"
fi


print_warning "即将更新本体版本..."
read -p "是否更新本体版本? (y/N): " confirm
if [[ $confirm == [yY] || $confirm == [yY][eE][sS] ]]; then
    # ======================
    # 1. 关闭并删除旧版本 g1robot
    # ======================
    if [ -d ~/g1robot ]; then
        print_info "进入 g1robot 目录，执行 full_close.sh"
        cd ~/g1robot
        check_status "进入~/g1robot目录成功" "进入~/g1robot目录失败"
        ./scripts/voice/setup_ssh_trust.sh || print_warning "未与ssh建立有效密钥连接,已忽略"
        if [ -x ./full_close.sh ]; then
            ./full_close.sh || print_warning "关闭脚本执行完成（可能有未运行的进程）"
            check_status "关闭脚本执行成功" "关闭脚本执行失败"
        else
            print_warning "警告: full_close.sh 不存在或不可执行，跳过关闭操作"
        fi
        print_info "正在返回主目录"
        cd ~/
        check_status "返回主目录成功" "返回主目录失败"
        print_info "删除旧版本的 g1robot"
        echo "$LOCAL_PASSWORD" | sudo -S rm -rf ~/g1robot
    else
        print_warning "未找到旧版本的 g1robot，跳过删除"
    fi

    # ======================
    # 2. 解压新版本 g1robot
    # ======================
    echo "使用新版本的 g1robot: $TAR_FILE"
    if [ ! -f "$TAR_FILE" ]; then
        print_error "压缩文件${TAR_FILE}不存在"
        exit 1
    fi

    print_info "正在解压文件..."
    tar -zxvf "$TAR_FILE"
    check_status "文件解压成功" "文件解压失败"

    # ======================
    # 3. 重命名 g1robot
    # ======================
    EXTRACTED_DIR=$(tar -tzf "$TAR_FILE" | head -1 | cut -f1 -d"/")
    if [ -z "$EXTRACTED_DIR" ]; then
        print_error "无法确定解压后的目录名"
        exit 1
    fi

    print_info "正在重命名解压目录..."
    if [ -d "$EXTRACTED_DIR" ]; then
        mv "$EXTRACTED_DIR" "g1robot"
        check_status "解压目录重命名成功: ${EXTRACTED_DIR} -> g1robot" "解压目录重命名失败"
    else
        print_error "解压后的目录${EXTRACTED_DIR}不存在"
        exit 1
    fi

    # ======================
    # 4. 执行安装脚本
    # ======================
    print_info "正在进入新目录..."
    cd ~/g1robot
    check_status "进入新目录成功" "进入新目录失败"

    voice_package=$(ls -t ~/g1robot/rk3588_voice_*.tar.gz 2>/dev/null | head -1 | xargs basename 2>/dev/null)

    if [ -z "$voice_package" ]; then
        echo "错误: 未找到语音包文件"
        exit 1
    fi

    print_info "使用语音包: $voice_package"

    print_info "正在进入package_install目录..."
    cd package_install
    check_status "进入package_install目录成功" "进入package_install目录失败"

    print_info "正在执行安装脚本..."
    ./install_common.sh
    check_status "安装脚本执行成功" "安装脚本执行失败"
else
    print_info "已取消更新"
fi

# ======================
# 5. 传输 voice_package 到远程主机
# ======================
print_warning "即将更新3588版本..."
read -p "是否更新3588版本? (y/N): " confirm
if [[ $confirm == [yY] || $confirm == [yY][eE][sS] ]]; then
    print_info "开始拷贝到3588..."
    if [ -f ~/g1robot/"$voice_package" ]; then
        echo "拷贝 "$voice_package" 到远程主机 ~/zrj_ws/"
        sshpass -p "$PASSWORD" scp ~/g1robot/"$voice_package" cat@192.168.123.188:~/zrj_ws/
        sshpass -p "$PASSWORD" scp ~/g1robot/boot_init.sh cat@192.168.123.188:~/zrj_ws/

        ###########  远程指令    ###########
        echo "===== 执行远程指令 ====="
        # ======================
        # 1. 远程ssh连接
        # ======================
        /usr/bin/expect <<EOF
        set timeout $TIMEOUT
        set host "$HOST"
        set user "$USER"
        set password "$PASSWORD"

        # 启动 SSH 连接
        spawn ssh \$user@\$host

        expect {
            # 首次连接时的 SSH 指纹验证
            "(yes/no)?" {
                send "yes\r"
                exp_continue
            }
            # 密码输入
            "*password:*" {
                send "\$password\r"
            }
        }

        # 等待远程 Shell 提示符（匹配 $ 或 # 结尾的行）
        expect {
            -re {.*[\$#] $} { 
                send "echo '成功登录 \$host'\r" 
            }
            timeout {
                send_user "连接异常：未获取到 Shell 提示符。\n"
                exit 1
            }
        }        

        # 进入工作目录
        expect -re {.*[\$#] $} { send "if \[ -d ~/zrj_ws \]; then cd ~/zrj_ws && echo '进入 zrj_ws 成功'; else echo '目录 zrj_ws 不存在，退出'; exit 1; fi\r" }

        # 删除旧版本
        expect -re {.*[\$#] $} { send "echo '删除旧版本的 app.bc'\r" }
        expect -re {.*[\$#] $} { send "if \[ -d g1_scripts \] || \[ -d hrobot-app \]; then sudo rm -rf g1_scripts hrobot-app && echo '旧版本已删除'; else echo '未找到旧版本，跳过删除'; fi\r" }

        # 解压新版本
        expect -re {.*[\$#] $} { send "echo '解压新版本的 app.bc'\r" }
        expect -re {.*[\$#] $} { send "if \[ -f '$voice_package' \]; then tar -zxvf '$voice_package' && echo '解压完成'; else echo '压缩包不存在，退出'; exit 1; fi\r" }
        expect -re {.*[\$#] $} { send "rm '$voice_package'\r" }

        # 安装语音助手
        expect -re {.*[\$#] $} { send "echo '进入语音助手安装服务'\r" }
        expect -re {.*[\$#] $} { send "sudo chmod +x g1_scripts/*.sh\r" }

        # 完成提示
        expect -re {.*[\$#] $} { send "sleep 5\r" }

        # ===============================
        # 退出远程会话
        # ===============================
        expect -re {.*[\$#] $} { send "echo '准备重启CAT设备...'\r" }
        expect -re {.*[\$#] $} { send "sudo reboot\r" }
        # 等待重启命令执行
        expect {
            "Connection closed" { 
                send_user "CAT设备正在重启...\n"
            }
            "closed by remote host" {
                send_user "CAT设备正在重启...\n"
            }
            timeout {
                send_user "重启命令已发送，等待设备重启...\n"
            }
            eof {
            }
        }

        send_user "等待远程主机重启...\n"
        exec sleep 80

        # 重新连接远程主机
        spawn ssh \$user@\$host
        expect {
            "(yes/no)?" {
                send "yes\r"
                exp_continue
            }
            "*password:*" {
                send "$password\r"
            }
        }

        expect -re {.*[\$#] $} { send "echo '远程主机重启完成，重新连接成功'\r" }
        expect -re {.*[\$#] $}
        # 检查 tmux 会话是否存在
        send "if tmux has-session -t homi_speech; then echo 'tmux会话存在' && exit 0; else echo 'tmux会话不存在' && exit 0; fi\r"

        # 等待 SSH 会话结束
        expect eof
EOF

        # 检查 expect 执行状态
        if [ $? -ne 0 ]; then
            echo "错误：远程指令执行失败！" >&2
            exit 1
        fi
    else
        echo "错误: 本地未找到 "$voice_package",无法传输"
        exit 1
    fi
else
    print_info "已取消更新"
fi


###########  本地指令    ###########
echo "===== 执行本地指令 ====="
# ======================
# 6. 重启系统
# ======================
print_warning "即将重启系统..."
read -p "是否立即重启系统? (y/N): " confirm
if [[ $confirm == [yY] || $confirm == [yY][eE][sS] ]]; then
    print_info "系统即将重启..."
    sudo reboot
else
    print_info "已取消重启，请手动执行 sudo reboot 来重启系统"
fi
